if(tutorial_settings == nil) then
  tutorial_settings = {played = false}
end
local played_in_past = tutorial_settings.played
state:on_save(function(save)
  tutorial_settings.played = true
  save:set("tutorial_settings", tutorial_settings)
end)

state:filter_interactions(function(i)
  return "This level does not allow interaction."
end)
function is_resize_open()
  local partial = state:get_partial_interaction()
  return partial.type == "PartialResize"
end
function open_resize_filter(i)
  return i == PlayerInteraction.start_resize or i == PlayerInteraction.cancel or i == PlayerInteraction.pause or i == PlayerInteraction.stop or i == PlayerInteraction.speed_up or i == PlayerInteraction.slow_down or i.type == "MotionAction" or i.type == "ZoomAction" or i == PlayerInteraction.undo
end
local function resize_action_filter(i)
  if i.type == "MouseEventAction" then
    return true
  elseif i.type == "MouseUpdateAction" then
    return true
  else
    return i == PlayerInteraction.start_resize or i == PlayerInteraction.cancel or i == PlayerInteraction.rotate_left or i == PlayerInteraction.rotate_right or i == PlayerInteraction.flip or i == PlayerInteraction.pause or i == PlayerInteraction.stop or i == PlayerInteraction.speed_up or i == PlayerInteraction.slow_down or i.type == "MotionAction" or i.type == "ZoomAction" or i == PlayerInteraction.undo
  end
end
local default_vertical = 0.4
local default_width = 34
local default_height = 23
local function is_default_size()
  local width, height = state:get_extent()
  return width == default_width and height == default_height
end
set_default_vertical(default_vertical)
function tutorial_routine_first()
  return coroutine.wrap(function()
    state:suppress_toolbar_menu();
    state:suppress_transport_menu(false);
    state:suppress_interface_hints();
    set_user_input_filter(restrictive_filter)
    embed(ramp(5, do_all(
      announce_lambda("We can change the size of factories.", 0.1),
      announce_lambda("(This feature is experimental)", 0.06, default_vertical - 0.09)
    ), captured_cancel()))
    embed(pause(0.2))
    embed(tutorial_routine_second())
  end)
end
function tutorial_routine_second()
  return coroutine.wrap(function()
    state:suppress_toolbar_menu();
    state:suppress_transport_menu(false);
    state:suppress_interface_hints();
    set_user_input_filter(resize_action_filter)
    while state:is_at_start() do
      embed(ramp_while(function() return not is_resize_open() and state:is_at_start() end, do_all(
        announce_lambda("Tool: Resize", 0.15),
        announce_lambda("Press 'g' to open.", 0.1, default_vertical - 0.14)
      ), captured_cancel()))
      embed(ramp_while(is_resize_open, do_all(
        announce_lambda("E/R to change direction.", 0.06, default_vertical + 0.12),
        announce_lambda("F to toggle between expand and collapse modes.", 0.06, default_vertical + 0.05),
        announce_lambda("Click to confirm.", 0.06, default_vertical - 0.02),
        announce_lambda("(Z to undo)", 0.04, default_vertical - 0.08)
      ), captured_cancel()))
    end
  end)
end

function tutorial_routine()
  if not played_in_past then
    return tutorial_routine_first()
  else
    return tutorial_routine_second()
  end
end


draw_interpreted_routine(tutorial_routine())
